/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class ASO
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        int value = (int)operand.getByte().getNumber();
        Flags6502 flags = cpu.getFlags();
        flags.setCarry((value = value << 1 | value) > 255);
        flags.setNZFromValue(value &= 0xFF);
        operand.setByte(new HwByte((long)value));
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "ASO";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(15, this, new Absolute());
        cset.defineCommand(31, this, new AbsoluteX());
        cset.defineCommand(27, this, new AbsoluteY());
        cset.defineCommand(7, this, new ZeroPage());
        cset.defineCommand(23, this, new ZeroPageX());
        cset.defineCommand(3, this, new IndirectX());
        cset.defineCommand(19, this, new IndirectY());
    }
}

